/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.launch;

import java.util.List;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.Blackboard;
import org.spongepowered.asm.launch.MixinInitialisationError;
import org.spongepowered.asm.launch.platform.MixinPlatformManager;
import org.spongepowered.asm.mixin.MixinEnvironment;

public abstract class MixinBootstrap {
    public static final String VERSION = "0.7";
    private static final String LAUNCH_PACKAGE = "org.spongepowered.asm.launch.";
    private static final String MIXIN_PACKAGE = "org.spongepowered.asm.mixin.";
    private static final String MIXIN_UTIL_PACKAGE = "org.spongepowered.asm.util.";
    private static final String ASM_PACKAGE = "org.spongepowered.asm.lib.";
    private static final String TRANSFORMER_PROXY_CLASS = "org.spongepowered.asm.mixin.transformer.MixinTransformer$Proxy";
    private static final Logger logger = LogManager.getLogger("mixin");
    private static boolean initialised = false;
    private static boolean initState = true;
    private static MixinPlatformManager platform;

    private MixinBootstrap() {
    }

    public static void addProxy() {
        Launch.classLoader.registerTransformer(TRANSFORMER_PROXY_CLASS);
    }

    public static MixinPlatformManager getPlatform() {
        if (platform == null) {
            platform = new MixinPlatformManager();
        }
        return platform;
    }

    public static void init() {
        if (!MixinBootstrap.start()) {
            return;
        }
        MixinBootstrap.doInit(null);
    }

    static boolean start() {
        if (MixinBootstrap.isSubsystemRegistered()) {
            if (!MixinBootstrap.checkSubsystemVersion()) {
                throw new MixinInitialisationError("Mixin subsystem version " + MixinBootstrap.getActiveSubsystemVersion() + " was already initialised. Cannot bootstrap version " + VERSION);
            }
            return false;
        }
        MixinBootstrap.registerSubsystem(VERSION);
        if (!initialised) {
            initialised = true;
            String command = System.getProperty("sun.java.command");
            if (command != null && command.contains("GradleStart")) {
                System.setProperty("mixin.env.disableRefMap", "true");
            }
            if (MixinBootstrap.findInStackTrace(Launch.class.getName(), "launch") > 132) {
                logger.error("Initialising mixin subsystem after game pre-init phase! Some mixins may be skipped.");
                MixinEnvironment.init(MixinEnvironment.Phase.DEFAULT);
                MixinBootstrap.getPlatform().prepare(null);
                initState = false;
            } else {
                MixinEnvironment.init(MixinEnvironment.Phase.PREINIT);
            }
            MixinBootstrap.addProxy();
        }
        MixinBootstrap.getPlatform();
        return true;
    }

    static void doInit(List<String> args2) {
        if (!initialised) {
            if (MixinBootstrap.isSubsystemRegistered()) {
                logger.warn("Multiple Mixin containers present, init suppressed for 0.7");
                return;
            }
            throw new IllegalStateException("MixinBootstrap.doInit() called before MixinBootstrap.start()");
        }
        MixinBootstrap.getPlatform().getPhaseProviderClasses();
        if (initState) {
            List tweakClasses;
            MixinBootstrap.getPlatform().prepare(args2);
            if (MixinBootstrap.findInStackTrace(Launch.class.getName(), "launch") < 4) {
                logger.warn("MixinBootstrap.doInit() called during a tweak constructor. Expect CoModificationException in 5.. 4..");
            }
            if ((tweakClasses = (List)Blackboard.get("TweakClasses")) != null) {
                tweakClasses.add(MixinEnvironment.class.getName() + "$EnvironmentStateTweaker");
            }
        }
    }

    static void injectIntoClassLoader(LaunchClassLoader classLoader) {
        MixinBootstrap.getPlatform().injectIntoClassLoader(classLoader);
    }

    private static boolean isSubsystemRegistered() {
        return Blackboard.get("mixin.initialised") != null;
    }

    private static boolean checkSubsystemVersion() {
        return VERSION.equals(MixinBootstrap.getActiveSubsystemVersion());
    }

    private static Object getActiveSubsystemVersion() {
        Object version = Blackboard.get("mixin.initialised");
        return version != null ? version : "";
    }

    private static void registerSubsystem(String version) {
        Blackboard.put("mixin.initialised", version);
    }

    private static int findInStackTrace(String className, String methodName) {
        StackTraceElement[] stackTrace;
        Thread currentThread = Thread.currentThread();
        if (!"main".equals(currentThread.getName())) {
            return 0;
        }
        for (StackTraceElement s : stackTrace = currentThread.getStackTrace()) {
            if (!className.equals(s.getClassName()) || !methodName.equals(s.getMethodName())) continue;
            return s.getLineNumber();
        }
        return 0;
    }

    static {
        Launch.classLoader.addClassLoaderExclusion(ASM_PACKAGE);
        Launch.classLoader.addClassLoaderExclusion(MIXIN_PACKAGE);
        Launch.classLoader.addClassLoaderExclusion(MIXIN_UTIL_PACKAGE);
        Launch.classLoader.addClassLoaderExclusion(LAUNCH_PACKAGE);
    }
}

